require("scripts/style.lua");
function GetBuyStyle()
	if (GetCurrentGameMode() ~= 0 and GetLevelMode() == 0)  then
		return SetStyle(MapTrialPlayJustBuyStyle);
	end
	return SetStyle(MapTrialPlayBuyStyle);
end
gProcessing = GetTimer();
function MakeBuyButton(name)
	return 	Group {
		GetBuyStyle(),
			
		Button 
		{
			x=0, y=0,
			label = "buyrestaurant",
			name = 'buy_' .. name,
			rolloverwindow = name .. '_rollover',
			command = 
				function()
					if (GetTimer() - gProcessing < 1500) then
						return;
					end
					gProcessing = GetTimer();
					
					if (IsFirstPeek()) then
						DisplayDialog {
							'scripts/ok.lua',
							body='notinfirstpeek',
							title=''
						};
					else
						if (name == 'harvest' or name == 'halloween') then
							LaunchStoreAutoAdd('dd4_' .. name);
						else
							LaunchStoreAutoAdd('dd4_restaurant_'..name);
						end
					end			
				end
		},
	}
end

function MakeTryButton(name)
	return Group {
		SetStyle(MapTrialPlayTryStyle),
		Button
		{
			x=0, y=88,
			label = "trialplaytry",
			name = 'try_' .. name,
			rolloverwindow = name .. '_rollover',
			command = 
				function()
					if (GetTimer() - gProcessing < 1500) then
						return;
					end
					gProcessing = GetTimer();
					
					TriggerTrialDownload(name, true);
				end
		};
	}
end

function MakeRollover(name, rollx, rolly)
	return Group {
		Bitmap
		{
			name = name ..'_rollover',
			x = rollx, y = rolly,
			image = 'map/restaurant_rollover',
			Text
			{	
				x = 0, y = 0,
				w = kMax, h = kMax,
				label = name .. "_name",
				font = RestaurantRolloverFont,
				flags = kHAlignCenter + kVAlignCenter
			};
			
		};
	}
end

function MakeRestaurantButtons(name, x, y, rollx, rolly)
	if (GetCurrentGameMode() ~= 0 and GetLevelMode() == 0)  then
		return Group {
			name = name,
			Window {
				x = x, y = y, w=kMax, h=kMax,
				MakeBuyButton(name),
			},	
			MakeRollover(name, rollx, rolly);
		}	
	end
	
	return Group {
		name = name,
		Window {
			x = x, y = y, w=kMax, h=kMax,
			MakeBuyButton(name),			
			MakeTryButton(name),
		},	
		MakeRollover(name, rollx, rolly);
	}	
end

function HideRestaurantButtons(restaurant)
	HideBuyButton(restaurant, 'buy_' .. restaurant);
	HideBuyButton(restaurant, 'try_' .. restaurant);
end